
*## Initial static model calibration (for initial period 2014)
*## "initsim.g00" work-file saved for subsequent dynamically-recursive simulations (over pre-simulation period 2014-2021 (tp))

PARAMETERS SAMscale        conversion from SAM import unit (bn INR) to basic unit /1E9/
           TARGETscale     conversion from basic unit to TARGET unit (bn INR) model unit /1E9/
           IMPORTscale_POP conversion from population import unit (1) to basic unit /1/
           TARGETscale_POP conversion from basic unit to TARGET population (1E3) model unit /1E3/
           INVscale        conversion from Investent units (bn INR) to Capital stock units (bn INR) /1/
           POPscale        conversion from demographic and TB model unit (1000' persons) to basic unit /1E3/
;

*## Calibration of static CGE model
$include mod101.gms

SET t1_tb /1*52/
    nonH(h,hp)
;

ALIAS (t1_tb,t1_tbp,t1_tbpp);

nonH(h,hp) = no;
nonH(h,hp)$(ord(h) <> ord(hp)) = yes;

*## Parameter definitions
$include parmdef.inc

*Scenario TABs
TAB_Scen01=0;
TAB_Scen02=0;
TAB_Scen02_1=0;
TAB_Scen03=0;

*## Calibration of TB-extended CGE model
$include modTB.gms

*## Definition and calculation of discount factor (over simulation period 2021-2040 (ts))
PARAMETER            dfactor        discount factor for NPV calculations (5-6% inflation rate + 4-5% real interest rate)  / 0.100 /
                     dfactor_t(t1)  discount factor for NPV calculations by time period (t1)
                     dGDPDEF_t(t1)  GDP deflator discount factor for NPV calculations by time period (t1)
;

dfactor_t(ts)$(ord(ts) eq 1) = 1;
loop(ts, dfactor_t(ts+1) = (1+dfactor)*dfactor_t(ts));
dfactor_t(ts) = SUM(tsp$(ord(tsp) eq 1),dfactor_t(tsp))/dfactor_t(ts);

Display dfactor_t;

ALIAS(tp,tpp), (insd,insdp);
